<?php
include '../config.php'; // Inajumuisha file ya connection

// Hakikisha folda za uploads zipo
$coverDir = '../uploads/products/covers/';
$galleryDir = '../uploads/products/gallery/';
if (!is_dir($coverDir)) {
    mkdir($coverDir, 0777, true);
}
if (!is_dir($galleryDir)) {
    mkdir($galleryDir, 0777, true);
}

$response = array('success' => false, 'message' => '');

$user_id    = isset($_POST['user_id']) ? $_POST['user_id'] : '';
$shop_id    = isset($_POST['shop_id']) ? $_POST['shop_id'] : '';
$name       = isset($_POST['name']) ? $_POST['name'] : '';
$description= isset($_POST['description']) ? $_POST['description'] : '';
$category   = isset($_POST['category']) ? $_POST['category'] : '';
$price      = isset($_POST['price']) ? $_POST['price'] : '';
$date       = date("Y-m-d H:i:s");

if(empty($user_id) || empty($shop_id) || empty($name) || empty($description) || empty($category) || empty($price)) {
    $response['message'] = 'Missing required fields';
    echo json_encode($response);
    exit;
}

// Pakia cover image
$cover_image = '';
if(isset($_FILES['cover_image']) && $_FILES['cover_image']['error'] == 0) {
    $cover_image = $coverDir . basename($_FILES['cover_image']['name']);
    if(!move_uploaded_file($_FILES['cover_image']['tmp_name'], $cover_image)){
        $response['message'] = 'Failed to upload cover image';
        echo json_encode($response);
        exit;
    }
    // Hifadhi jina tu
    $cover_image = basename($cover_image);
}

// Ingiza data kwenye meza ya products
$stmt = $conn->prepare("INSERT INTO products (user_id, shop_id, name, description, category, price, cover_image, date) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
$stmt->bind_param("iisssdss", $user_id, $shop_id, $name, $description, $category, $price, $cover_image, $date);

if($stmt->execute()){
    $product_id = $stmt->insert_id;
    // Pitia gallery images ikiwa zipo
    if(isset($_FILES['gallery_images'])){
        foreach($_FILES['gallery_images']['tmp_name'] as $key => $tmp_name){
            if($_FILES['gallery_images']['error'][$key] == 0 && !empty($_FILES['gallery_images']['name'][$key])){
                $galleryImageName = basename($_FILES['gallery_images']['name'][$key]);
                $targetPath = $galleryDir . $galleryImageName;
                if(move_uploaded_file($tmp_name, $targetPath)){
                    $stmt_gallery = $conn->prepare("INSERT INTO product_gallery (product_id, image) VALUES (?, ?)");
                    $stmt_gallery->bind_param("is", $product_id, $galleryImageName);
                    $stmt_gallery->execute();
                }
            }
        }
    }
    $response['success'] = true;
    $response['message'] = 'Product added successfully';
} else {
    $response['message'] = 'Failed to add product';
}
$stmt->close();
echo json_encode($response);
?>
