<?php
header("Content-Type: application/json");

include '../config.php';

// Define base url for images
$baseUrl = "https://api.myshop.co.tz/uploads/products/covers/";

// Pata user id kutoka GET
$user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;

if ($user_id <= 0) {
    echo json_encode(["error" => "Invalid user id"]);
    exit;
}

// Andaa SQL query ili kuchuja bidhaa kwa user_id husika
$sql = "SELECT `id`, `user_id`, `shop_id`, `name`, `description`, `category`, `price`, `cover_image`, `date` 
        FROM `products` 
        WHERE `user_id` = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

$products = [];
while ($row = $result->fetch_assoc()) {
    // Append the base URL to the cover_image file name
    $row['cover_image'] = $baseUrl . $row['cover_image'];
    $products[] = $row;
}

echo json_encode($products);

$stmt->close();
$conn->close();
?>
