<?php
require_once '../config.php'; // Hakikisha njia ni sahihi

$baseUrl = "https://api.myshop.co.tz/"; // Base URL ya API yako

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Pata user_id kutoka POST data
    $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : '';
    
    if(empty($user_id)) {
        echo json_encode(["success" => false, "message" => "Missing user_id"]);
        exit;
    }
    
    // Andaa SQL query ya kuchukua shops za user
    $stmt = $conn->prepare("SELECT id, shop_name, location, user_id, cover_image, profile_image, created_at FROM shops WHERE user_id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $shops = array();
    while($row = $result->fetch_assoc()){
        // Kama cover_image ipo, weka base URL na folder ya covers
        if (!empty($row['cover_image'])) {
            $row['cover_image'] = $baseUrl . "uploads/shops/covers/" . $row['cover_image'];
        } else {
            $row['cover_image'] = "";
        }
        // Kama profile_image ipo, weka base URL na folder ya profiles
        if (!empty($row['profile_image'])) {
            $row['profile_image'] = $baseUrl . "uploads/shops/profiles/" . $row['profile_image'];
        } else {
            $row['profile_image'] = "";
        }
        $shops[] = $row;
    }
    
    echo json_encode(["success" => true, "shops" => $shops]);
    $stmt->close();
    $conn->close();
} else {
    echo json_encode(["success" => false, "message" => "Invalid request method"]);
}
?>
